/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.n.NivixAerieOfTheFiremindCanCastEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class NivixAerieOfTheFiremindEffect
extends OneShotEffect {
    NivixAerieOfTheFiremindEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of your library. Until your next turn, you may cast it if it's an instant or sorcery spell";
    }

    private NivixAerieOfTheFiremindEffect(NivixAerieOfTheFiremindEffect effect) {
        super((OneShotEffect)effect);
    }

    public NivixAerieOfTheFiremindEffect copy() {
        return new NivixAerieOfTheFiremindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            Library library = controller.getLibrary();
            if (library.hasCards() && (card = library.getFromTop(game)) != null && controller.moveCardsToExile(card, source, game, true, source.getSourceId(), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null)) && card.isInstantOrSorcery(game)) {
                NivixAerieOfTheFiremindCanCastEffect effect = new NivixAerieOfTheFiremindCanCastEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

