/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.n.NoeticScalesPredicate;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class NoeticScalesEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    NoeticScalesEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "return to its owner's hand each creature that player controls with power greater than the number of cards in their hand";
    }

    private NoeticScalesEffect(NoeticScalesEffect effect) {
        super((OneShotEffect)effect);
    }

    public NoeticScalesEffect copy() {
        return new NoeticScalesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getBattlefield().getActivePermanents(filter, game.getActivePlayerId(), source, game).stream().filter(Objects::nonNull).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }

    static {
        filter.add((Predicate)NoeticScalesPredicate.instance);
    }
}

