/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.InvertCondition;
import mage.abilities.condition.common.TargetAttackedThisTurnCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NorrittDelayedDestroyEffect
extends OneShotEffect {
    NorrittDelayedDestroyEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy it at the beginning of the next end step if it didn't attack this turn";
    }

    private NorrittDelayedDestroyEffect(NorrittDelayedDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public NorrittDelayedDestroyEffect copy() {
        return new NorrittDelayedDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        DestroyTargetEffect effect = new DestroyTargetEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
        AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect, TargetController.ANY, (Condition)new InvertCondition((Condition)TargetAttackedThisTurnCondition.instance));
        delayedAbility.getTargets().addAll((Collection)source.getTargets());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        return true;
    }
}

