/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateRoleAttachedTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.RoleType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class NotDeadAfterAllEffect
extends OneShotEffect {
    NotDeadAfterAllEffect() {
        super(Outcome.Benefit);
        this.staticText = "return it to the battlefield tapped under its owner's control, then create a Wicked Role token attached to it.";
    }

    private NotDeadAfterAllEffect(NotDeadAfterAllEffect effect) {
        super((OneShotEffect)effect);
    }

    public NotDeadAfterAllEffect copy() {
        return new NotDeadAfterAllEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (player == null || card == null) {
            return false;
        }
        if (game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        return new CreateRoleAttachedTargetEffect(RoleType.WICKED).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)).apply(game, source);
    }
}

