/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.players.Player;

class NotForgottenEffect
extends OneShotEffect {
    public NotForgottenEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put target card from a graveyard on the top or bottom of its owner's library. Create a 1/1 white Spirit creature token with flying.";
    }

    private NotForgottenEffect(NotForgottenEffect effect) {
        super((OneShotEffect)effect);
    }

    public NotForgottenEffect copy() {
        return new NotForgottenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean onTop;
        boolean moved;
        Player controller = game.getPlayer(source.getControllerId());
        Card targetCard = game.getCard(source.getFirstTarget());
        if (controller != null && targetCard != null && (moved = controller.moveCardToLibraryWithInfo(targetCard, source, game, Zone.GRAVEYARD, onTop = controller.chooseUse(this.outcome, "Put " + targetCard.getName() + " on top of it's owners library (otherwise on bottom)?", source, game), true))) {
            SpiritWhiteToken token = new SpiritWhiteToken();
            token.putOntoBattlefield(1, game, source, source.getControllerId(), false, false);
            return true;
        }
        return false;
    }
}

