/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NowhereToRunHexproofEffect
extends AsThoughEffectImpl {
    NowhereToRunHexproofEffect() {
        super(AsThoughEffectType.HEXPROOF, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Creatures your opponents control can be the targets of spells and abilities as though they didn't have hexproof.";
    }

    private NowhereToRunHexproofEffect(NowhereToRunHexproofEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (affectedControllerId.equals(source.getControllerId())) {
            Permanent creature = game.getPermanent(sourceId);
            return creature != null && creature.isCreature(game) && game.getOpponents(source.getControllerId()).contains(creature.getControllerId());
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public AsThoughEffect copy() {
        return new NowhereToRunHexproofEffect(this);
    }
}

