/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.n.AwakenElementalToken;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NoyanDarEffect
extends OneShotEffect {
    NoyanDarEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put three +1/+1 counters on target land you control. If you do, that land becomes a 0/0 Elemental creature with haste that's still a land.";
    }

    private NoyanDarEffect(NoyanDarEffect effect) {
        super((OneShotEffect)effect);
    }

    public NoyanDarEffect copy() {
        return new NoyanDarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = null;
        for (Target target : source.getTargets()) {
            targetId = target.getFirstTarget();
        }
        if (targetId != null) {
            FixedTarget blueprintTarget = new FixedTarget(targetId, game);
            BecomesCreatureTargetEffect continuousEffect = new BecomesCreatureTargetEffect((Token)new AwakenElementalToken(), false, true, Duration.EndOfGame);
            continuousEffect.setTargetPointer((TargetPointer)blueprintTarget.copy());
            game.addEffect((ContinuousEffect)continuousEffect, source);
            AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(3));
            effect.setTargetPointer((TargetPointer)blueprintTarget.copy());
            return effect.apply(game, source);
        }
        return true;
    }
}

