/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class NukaNukeLauncherDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private UUID playerId = null;

    NukaNukeLauncherDelayedTriggeredAbility() {
        super((Effect)new AddCountersTargetEffect(CounterType.RAD.createInstance(2)), Duration.Custom, false, false);
    }

    private NukaNukeLauncherDelayedTriggeredAbility(NukaNukeLauncherDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public NukaNukeLauncherDelayedTriggeredAbility copy() {
        return new NukaNukeLauncherDelayedTriggeredAbility(this);
    }

    public void init(Game game) {
        super.init(game);
        this.playerId = this.getEffects().stream().map(Effect::getTargetPointer).map(targetPointer -> targetPointer.getFirst(game, (Ability)this)).findAny().orElse(null);
    }

    public boolean isInactive(Game game) {
        if (this.playerId == null) {
            return true;
        }
        if (game.isActivePlayer(this.playerId)) {
            this.setDuration(Duration.EndOfTurn);
        }
        return super.isInactive(game);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        return spell != null && spell.isControlledBy(this.playerId);
    }

    public String getRule() {
        return "Until the end of defending player's next turn, that player gets two rad counters whenever they cast a spell";
    }
}

