/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class NullChamberChooseEffect
extends OneShotEffect {
    public static final String INFO_KEY_CONTROLLER = "CONTROLLER_NAMED_CARD";
    public static final String INFO_KEY_OPPONENT = "OPPONENT_NAMED_CARD";

    public NullChamberChooseEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "you and an opponent each choose a card name other than a basic land card name";
    }

    private NullChamberChooseEffect(NullChamberChooseEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        TargetOpponent chosenOpponent = new TargetOpponent(true);
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanentEntering(source.getSourceId());
        if (sourceObject == null) {
            sourceObject = source.getSourceObject(game);
        }
        if (controller == null || sourceObject == null) {
            return false;
        }
        controller.choose(Outcome.Neutral, (Target)chosenOpponent, source, game);
        Player opponent = game.getPlayer(chosenOpponent.getFirstTarget());
        String cardName = ChooseACardNameEffect.TypeOfName.NOT_BASIC_LAND_NAME.getChoice(controller, game, source, false);
        if (cardName != null) {
            game.getState().setValue(source.getSourceId().toString() + INFO_KEY_CONTROLLER, (Object)cardName);
            if (sourceObject instanceof Permanent) {
                sourceObject.addInfo(INFO_KEY_CONTROLLER, CardUtil.addToolTipMarkTags((String)("Named card (Controller): " + cardName)), game);
            }
        }
        if (opponent == null) {
            return true;
        }
        cardName = ChooseACardNameEffect.TypeOfName.NOT_BASIC_LAND_NAME.getChoice(opponent, game, source, false);
        if (cardName == null) {
            return true;
        }
        game.getState().setValue(source.getSourceId().toString() + INFO_KEY_OPPONENT, (Object)cardName);
        if (sourceObject instanceof Permanent) {
            sourceObject.addInfo(INFO_KEY_OPPONENT, CardUtil.addToolTipMarkTags((String)("Named card (Opponent): " + cardName)), game);
        }
        return true;
    }

    public NullChamberChooseEffect copy() {
        return new NullChamberChooseEffect(this);
    }
}

