/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NurturingPixieEffect
extends OneShotEffect {
    NurturingPixieEffect() {
        super(Outcome.Benefit);
        this.staticText = "return up to one target non-Faerie, nonland permanent you control to its owner's hand. If a permanent was returned this way, put a +1/+1 counter on {this}";
    }

    private NurturingPixieEffect(NurturingPixieEffect effect) {
        super((OneShotEffect)effect);
    }

    public NurturingPixieEffect copy() {
        return new NurturingPixieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(p -> p.addCounters(CounterType.P1P1.createInstance(), source, game));
        return true;
    }
}

