/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.SacrificeCost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SacrificeXManaValueCost
extends VariableCostImpl
implements SacrificeCost {
    protected final FilterControlledPermanent filter;

    public SacrificeXManaValueCost(FilterControlledPermanent filter, boolean useAsAdditionalCost) {
        super(useAsAdditionalCost ? VariableCostType.ADDITIONAL : VariableCostType.NORMAL, filter.getMessage() + " with manavalue X to sacrifice");
        this.text = (useAsAdditionalCost ? "sacrifice " : "Sacrifice ") + filter.getMessage() + " with mana value " + this.xText;
        this.filter = filter;
    }

    private SacrificeXManaValueCost(SacrificeXManaValueCost cost) {
        super((VariableCostImpl)cost);
        this.filter = cost.filter;
    }

    public SacrificeXManaValueCost copy() {
        return new SacrificeXManaValueCost(this);
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        FilterControlledPermanent manavaluefilter = new FilterControlledPermanent(this.filter.getMessage() + " with mana value " + xValue);
        manavaluefilter.add((Predicate)this.filter.getPredicates().get(0));
        manavaluefilter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, xValue));
        return new SacrificeTargetCost((FilterPermanent)manavaluefilter);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        int validTargets = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)this.filter, controllerId, game)) {
            if (!controller.canPaySacrificeCost(permanent, source, controllerId, game)) continue;
            ++validTargets;
        }
        return validTargets > 0;
    }

    public int getMaxValue(Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return super.getMaxValue(source, game);
        }
        int maxValue = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)this.filter, controller.getId(), game)) {
            if (!controller.canPaySacrificeCost(permanent, source, controller.getId(), game)) continue;
            maxValue = Math.max(maxValue, permanent.getManaValue());
        }
        return maxValue;
    }
}

