/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class TargetCreatureWithLessPowerPermanent
extends TargetPermanent {
    public TargetCreatureWithLessPowerPermanent() {
        super(1, 1, (FilterPermanent)new FilterCreaturePermanent("creature with power less than its power"), false);
    }

    private TargetCreatureWithLessPowerPermanent(TargetCreatureWithLessPowerPermanent target) {
        super((TargetPermanent)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Permanent firstPermanent = game.getPermanent(source.getFirstTarget());
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
            if (firstPermanent == null) {
                possibleTargets.add(permanent.getId());
                continue;
            }
            if (firstPermanent.getPower().getValue() <= permanent.getPower().getValue()) continue;
            possibleTargets.add(permanent.getId());
        }
        possibleTargets.removeIf(id -> firstPermanent != null && firstPermanent.getId().equals(id));
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public TargetCreatureWithLessPowerPermanent copy() {
        return new TargetCreatureWithLessPowerPermanent(this);
    }
}

