/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class OKagachiMadeManifestEffect
extends OneShotEffect {
    OKagachiMadeManifestEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player chooses a nonland card in your graveyard. Return that card to your hand. {this} gets +X/+0 until end of turn, where X is the mana value of that card";
    }

    private OKagachiMadeManifestEffect(OKagachiMadeManifestEffect effect) {
        super((OneShotEffect)effect);
    }

    public OKagachiMadeManifestEffect copy() {
        return new OKagachiMadeManifestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        switch (controller.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND, game)) {
            case 0: {
                return false;
            }
            case 1: {
                card = controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND, game).stream().findFirst().orElse(null);
                break;
            }
            default: {
                TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
                target.withNotTarget(true);
                player.choose(Outcome.ReturnToHand, (Cards)controller.getGraveyard(), (TargetCard)target, source, game);
                card = game.getCard(target.getFirstTarget());
            }
        }
        if (card == null) {
            return false;
        }
        int manaValue = card.getManaValue();
        player.moveCards(card, Zone.HAND, source, game);
        if (manaValue > 0) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(manaValue, 0, Duration.EndOfTurn), source);
        }
        return true;
    }
}

