/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class OKagachiVengefulKamiWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> playerMap = new HashMap<UUID, Set<UUID>>();

    OKagachiVengefulKamiWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case BEGINNING_PHASE_PRE: {
                this.playerMap.remove(game.getActivePlayerId());
                return;
            }
            case ATTACKER_DECLARED: {
                UUID attacker = event.getPlayerId();
                Set<UUID> defenders = this.playerMap.get(attacker);
                if (defenders == null) {
                    defenders = new HashSet<UUID>();
                }
                defenders.add(event.getTargetId());
                this.playerMap.put(attacker, defenders);
            }
        }
    }

    boolean checkPlayer(UUID attackerId, UUID defenderId) {
        Set<UUID> defendersLastTurn;
        if (attackerId != null && defenderId != null && (defendersLastTurn = this.playerMap.get(defenderId)) != null) {
            return defendersLastTurn.contains(attackerId);
        }
        return false;
    }
}

