/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayTargetPlayerEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OathOfLiegesEffect
extends OneShotEffect {
    OathOfLiegesEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player chooses target player who controls more lands than they do and is their opponent. The first player may search their library for a basic land card, put that card onto the battlefield, then shuffle";
    }

    private OathOfLiegesEffect(OathOfLiegesEffect effect) {
        super((OneShotEffect)effect);
    }

    public OathOfLiegesEffect copy() {
        return new OathOfLiegesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        if (activePlayer != null) {
            if (activePlayer.chooseUse(this.outcome, "Search your library for a basic land card, put that card onto the battlefield, then shuffle?", source, game)) {
                SearchLibraryPutInPlayTargetPlayerEffect effect = new SearchLibraryPutInPlayTargetPlayerEffect(new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), false, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(game.getActivePlayerId()));
                return effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

