/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.watchers.common.PlayerGainedLifeWatcher;

class OathswornVampirePlayEffect
extends AsThoughEffectImpl {
    OathswornVampirePlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard if you gained life this turn";
    }

    private OathswornVampirePlayEffect(OathswornVampirePlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public OathswornVampirePlayEffect copy() {
        return new OathswornVampirePlayEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        PlayerGainedLifeWatcher watcher = (PlayerGainedLifeWatcher)game.getState().getWatcher(PlayerGainedLifeWatcher.class);
        if (watcher == null || watcher.getLifeGained(source.getControllerId()) < 1 || !sourceId.equals(source.getSourceId()) || !source.isControlledBy(affectedControllerId)) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        return card != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD;
    }
}

