/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.LifeLostBatchEvent;
import mage.game.events.LifeLostEvent;
import mage.util.CardUtil;

class ObNixilisCaptiveKingpinAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<LifeLostEvent> {
    ObNixilisCaptiveKingpinAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("Whenever one or more opponents each lose exactly 1 life, ");
    }

    private ObNixilisCaptiveKingpinAbility(ObNixilisCaptiveKingpinAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_LIFE_BATCH;
    }

    public boolean checkEvent(LifeLostEvent event, Game game) {
        return game.getOpponents(this.getControllerId()).contains(event.getTargetId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        List filteredEvents = this.getFilteredEvents((BatchEvent)((LifeLostBatchEvent)event), game);
        if (filteredEvents.isEmpty()) {
            return false;
        }
        return CardUtil.getEventTargets((GameEvent)event).stream().allMatch(uuid -> LifeLostBatchEvent.getLifeLostByPlayer((Collection)filteredEvents, (UUID)uuid) <= 1);
    }

    public ObNixilisCaptiveKingpinAbility copy() {
        return new ObNixilisCaptiveKingpinAbility(this);
    }
}

