/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ObNixilisTheAdversaryDiscardEffect
extends OneShotEffect {
    ObNixilisTheAdversaryDiscardEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Each opponent loses 2 life unless they discard a card. If you control a Demon or Devil, you gain 2 life";
    }

    private ObNixilisTheAdversaryDiscardEffect(ObNixilisTheAdversaryDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public ObNixilisTheAdversaryDiscardEffect copy() {
        return new ObNixilisTheAdversaryDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        for (UUID opponentId : game.getOpponents(controllerId)) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.getHand().isEmpty() && opponent.chooseUse(Outcome.Discard, "Discard a card or lose 2 life?", null, "Discard Card", "Lose 2 Life", source, game) && !opponent.discard(1, false, false, source, game).isEmpty()) continue;
            opponent.loseLife(2, game, source, false);
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(controllerId)) {
            if (!permanent.hasSubtype(SubType.DEMON, game) && !permanent.hasSubtype(SubType.DEVIL, game)) continue;
            controller.gainLife(2, game, source);
            break;
        }
        return true;
    }
}

