/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class OboshThePreypiercerEffect
extends ReplacementEffectImpl {
    OboshThePreypiercerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source you control with an odd mana value would deal damage to a permanent or player, it deals double that damage to that permanent or player instead.";
    }

    private OboshThePreypiercerEffect(OboshThePreypiercerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public OboshThePreypiercerEffect copy() {
        return new OboshThePreypiercerEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.DAMAGE_PLAYER) || event.getType().equals((Object)GameEvent.EventType.DAMAGE_PERMANENT);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject sourceObject = game.getObject(event.getSourceId());
        return sourceObject != null && sourceObject.getManaValue() % 2 == 1 && game.getControllerId(event.getSourceId()).equals(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

