/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ObservedStasisEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    ObservedStasisEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove enchanted creature from combat. Then draw a card for each tapped creature its controller controls";
    }

    private ObservedStasisEffect(ObservedStasisEffect effect) {
        super((OneShotEffect)effect);
    }

    public ObservedStasisEffect copy() {
        return new ObservedStasisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
        if (permanent == null) {
            return false;
        }
        game.getCombat().removeAttacker(permanent.getId(), game);
        int count = game.getBattlefield().count(filter, permanent.getControllerId(), source, game);
        if (count > 0) {
            Optional.ofNullable(source.getControllerId()).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.drawCards(count, source, game));
        }
        return true;
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
    }
}

