/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ObstinateFamiliarReplacementEffect
extends ReplacementEffectImpl {
    ObstinateFamiliarReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card, you may skip that draw instead";
    }

    private ObstinateFamiliarReplacementEffect(ObstinateFamiliarReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ObstinateFamiliarReplacementEffect copy() {
        return new ObstinateFamiliarReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player you = game.getPlayer(source.getControllerId());
        return you != null && you.chooseUse(Outcome.AIDontUseIt, "Skip this draw?", source, game);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent archmage = game.getPermanent(source.getSourceId());
        return archmage != null && event.getPlayerId().equals(source.getControllerId());
    }
}

