/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class OccupationTapEffect
extends ReplacementEffectImpl {
    OccupationTapEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Tap);
        this.staticText = "Creatures your opponents control enter the battlefield tapped";
    }

    private OccupationTapEffect(OccupationTapEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent target = ((EntersTheBattlefieldEvent)event).getTarget();
        if (target != null) {
            target.setTapped(true);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
            return permanent != null && permanent.isCreature(game);
        }
        return false;
    }

    public OccupationTapEffect copy() {
        return new OccupationTapEffect(this);
    }
}

