/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BloodToken;

class OdricBloodCursedEffect
extends OneShotEffect {
    OdricBloodCursedEffect() {
        super(Outcome.Benefit);
        this.staticText = "create X Blood tokens, where X is the number of abilities from among flying, first strike, double strike, deathtouch, haste, hexproof, indestructible, lifelink, menace, reach, trample, and vigilance found among creatures you control";
    }

    private OdricBloodCursedEffect(OdricBloodCursedEffect effect) {
        super((OneShotEffect)effect);
    }

    public OdricBloodCursedEffect copy() {
        return new OdricBloodCursedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int flying = 0;
        int firstStrike = 0;
        int doubleStrike = 0;
        int deathtouch = 0;
        int haste = 0;
        int hexproof = 0;
        int indestructible = 0;
        int lifelink = 0;
        int menance = 0;
        int reach = 0;
        int trample = 0;
        int vigilance = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (!permanent.isCreature(game)) continue;
            for (Ability ability : permanent.getAbilities(game)) {
                if (ability instanceof FlyingAbility) {
                    flying = 1;
                }
                if (ability instanceof FirstStrikeAbility) {
                    firstStrike = 1;
                }
                if (ability instanceof DoubleStrikeAbility) {
                    doubleStrike = 1;
                }
                if (ability instanceof DeathtouchAbility) {
                    deathtouch = 1;
                }
                if (ability instanceof HasteAbility) {
                    haste = 1;
                }
                if (ability instanceof HexproofAbility) {
                    hexproof = 1;
                }
                if (ability instanceof IndestructibleAbility) {
                    indestructible = 1;
                }
                if (ability instanceof LifelinkAbility) {
                    lifelink = 1;
                }
                if (ability instanceof MenaceAbility) {
                    menance = 1;
                }
                if (ability instanceof ReachAbility) {
                    reach = 1;
                }
                if (ability instanceof TrampleAbility) {
                    trample = 1;
                }
                if (!(ability instanceof VigilanceAbility)) continue;
                vigilance = 1;
            }
        }
        int numTokens = flying + firstStrike + doubleStrike + deathtouch + haste + hexproof + indestructible + lifelink + menance + reach + trample + vigilance;
        if (numTokens < 1) {
            return false;
        }
        return new BloodToken().putOntoBattlefield(numTokens, game, source, source.getControllerId());
    }
}

