/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.Target;

class OfficiousInterrogationCostIncreasingEffect
extends CostModificationEffectImpl {
    OfficiousInterrogationCostIncreasingEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "This spell costs {W}{U} more to cast for each target beyond the first.";
    }

    private OfficiousInterrogationCostIncreasingEffect(OfficiousInterrogationCostIncreasingEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public OfficiousInterrogationCostIncreasingEffect copy() {
        return new OfficiousInterrogationCostIncreasingEffect(this);
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.getSourceId().equals(source.getSourceId()) && abilityToModify instanceof SpellAbility;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Target target = (Target)abilityToModify.getTargets().get(0);
        int additionalTargets = target.getTargets().size() - 1;
        if (additionalTargets > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < additionalTargets; ++i) {
                sb.append("{W}{U}");
            }
            abilityToModify.addManaCostsToPay((ManaCost)new ManaCostsImpl(sb.toString()));
            return true;
        }
        return false;
    }
}

