/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.replacement.ThatSpellGraveyardExileReplacementEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OgreBattlecasterEffect
extends OneShotEffect {
    OgreBattlecasterEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may cast target instant or sorcery card from your graveyard by paying {R}{R} in addition to its other costs. If that spell would be put into a graveyard, exile it instead. When you cast that spell, {this} gets +X/+0 until end of turn, where X is that spell's mana value";
    }

    private OgreBattlecasterEffect(OgreBattlecasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public OgreBattlecasterEffect copy() {
        return new OgreBattlecasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null) {
            return false;
        }
        if (controller.chooseUse(Outcome.Benefit, "Cast " + card.getLogName() + '?', source, game)) {
            ThatSpellGraveyardExileReplacementEffect effect;
            int originalManaValue = card.getManaValue();
            card.getSpellAbility().addCost((Cost)new ManaCostsImpl("{R}{R}"));
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
            boolean cardWasCast = controller.cast(controller.chooseAbilityForCast(card, game, false), game, false, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
            if (cardWasCast) {
                effect = new BoostTargetEffect(originalManaValue, 0, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId()));
                game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)effect, false, "When you cast that spell, {this} gets +X/+0 until end of turn, where X is that spell's mana value"), source);
            }
            effect = new ThatSpellGraveyardExileReplacementEffect(false);
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

