/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.CantBeBlockedSourceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class OgreMarauderEffect
extends OneShotEffect {
    OgreMarauderEffect() {
        super(Outcome.Benefit);
        this.staticText = "it gains \"{this} can't be blocked\" until end of turn unless defending player sacrifices a creature";
    }

    private OgreMarauderEffect(OgreMarauderEffect effect) {
        super((OneShotEffect)effect);
    }

    public OgreMarauderEffect copy() {
        return new OgreMarauderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID defendingPlayerId = game.getCombat().getDefendingPlayerId(source.getSourceId(), game);
        MageObject sourceObject = game.getObject(source);
        Player defender = game.getPlayer(defendingPlayerId);
        if (defender != null && sourceObject != null) {
            SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            boolean paid = false;
            if (cost.canPay(source, source, defendingPlayerId, game) && defender.chooseUse(Outcome.LoseAbility, "Sacrifice a creature to prevent " + sourceObject.getLogName() + " from gaining \"" + sourceObject.getName() + " can't be blocked\"?", source, game)) {
                paid = cost.pay(source, game, source, defendingPlayerId, false, null);
            }
            if (!paid) {
                GainAbilitySourceEffect effect = new GainAbilitySourceEffect((Ability)new CantBeBlockedSourceAbility(), Duration.EndOfTurn);
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

