/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;

class OjerTaqDeepestFoundationTriplingEffect
extends ReplacementEffectImpl {
    OjerTaqDeepestFoundationTriplingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Copy);
        this.staticText = "If one or more creature tokens would be created under your control, three times that many of those tokens are created instead.";
    }

    private OjerTaqDeepestFoundationTriplingEffect(OjerTaqDeepestFoundationTriplingEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public OjerTaqDeepestFoundationTriplingEffect copy() {
        return new OjerTaqDeepestFoundationTriplingEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId()) && ((CreateTokenEvent)event).getTokens().entrySet().stream().anyMatch(entry -> ((Token)entry.getKey()).isCreature(game) && (Integer)entry.getValue() > 0);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event instanceof CreateTokenEvent) {
            ((CreateTokenEvent)event).multiplyTokens(3, token -> token.isCreature(game));
        }
        return false;
    }
}

