/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OketraTheTrueRestrictionEffect
extends RestrictionEffect {
    OketraTheTrueRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack or block unless you control at least three other creatures";
    }

    private OketraTheTrueRestrictionEffect(OketraTheTrueRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public OketraTheTrueRestrictionEffect copy() {
        return new OketraTheTrueRestrictionEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new ControllerIdPredicate(source.getControllerId()));
        if (permanent.getId().equals(source.getSourceId())) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                int permanentsOnBattlefield = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
                return ComparisonType.compare((int)permanentsOnBattlefield, (ComparisonType)ComparisonType.FEWER_THAN, (int)4);
            }
            return true;
        }
        return false;
    }
}

