/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterBlockingCreature;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OkkBlockEffect
extends RestrictionEffect {
    private static final FilterBlockingCreature filter = new FilterBlockingCreature("Blocking creatures");

    public OkkBlockEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't block unless a creature with greater power also blocks.";
    }

    private OkkBlockEffect(OkkBlockEffect effect) {
        super((RestrictionEffect)effect);
    }

    public OkkBlockEffect copy() {
        return new OkkBlockEffect(this);
    }

    public boolean canBlockCheckAfter(Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                if (creature.getPower().getValue() <= permanent.getPower().getValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

