/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.o.OlagLudevicsHubrisCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;
import mage.util.functions.CopyApplier;

class OlagLudevicsHubrisEffect
extends ReplacementEffectImpl {
    OlagLudevicsHubrisEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as this creature transforms into {this}, it becomes a copy of a creature card exiled with it, except its name is Olag, Ludevic's Hubris, it's 4/4, and it's a legendary blue and black Zombie in addition to its other colors and types. Put a number of +1/+1 counters on {this} equal to the number of creature cards exiled with it";
    }

    private OlagLudevicsHubrisEffect(OlagLudevicsHubrisEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)exileZone);
        cards.removeIf(uuid -> !game.getCard(uuid).isCreature(game));
        if (cards.isEmpty()) {
            return false;
        }
        Card copyFromCard = this.getCard((Cards)cards, source, game);
        if (copyFromCard == null) {
            return false;
        }
        PermanentCard newBluePrint = new PermanentCard(copyFromCard, source.getControllerId(), game);
        newBluePrint.assignNewId();
        OlagLudevicsHubrisCopyApplier applier = new OlagLudevicsHubrisCopyApplier();
        applier.apply(game, (MageObject)newBluePrint, source, source.getSourceId());
        CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)newBluePrint, source.getSourceId());
        copyEffect.setApplier((CopyApplier)applier);
        Ability newAbility = source.copy();
        copyEffect.init(newAbility, game);
        game.addEffect((ContinuousEffect)copyEffect, newAbility);
        return false;
    }

    private Card getCard(Cards cards, Ability source, Game game) {
        if (cards.size() == 1) {
            return cards.getRandom(game);
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return cards.getRandom(game);
        }
        TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD);
        player.choose(this.outcome, (Target)target, source, game);
        return cards.get(target.getFirstTarget(), game);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRANSFORMING;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getTargetId()) && source.getSourcePermanentIfItStillExists(game) != null;
    }

    public OlagLudevicsHubrisEffect copy() {
        return new OlagLudevicsHubrisEffect(this);
    }
}

