/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.mana.SimpleManaAbility;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TrollWarriorToken;
import mage.target.Target;
import mage.target.TargetPermanent;

class OldGrowthTrollContinuousEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.FOREST);
    private final int zoneChangeCounter;

    OldGrowthTrollContinuousEffect(int zoneChangeCounter) {
        super(Duration.Custom, Outcome.Neutral);
        this.zoneChangeCounter = zoneChangeCounter;
        this.dependencyTypes.add(DependencyType.AuraAddingRemoving);
    }

    private OldGrowthTrollContinuousEffect(OldGrowthTrollContinuousEffect ability) {
        super((ContinuousEffectImpl)ability);
        this.zoneChangeCounter = ability.zoneChangeCounter;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (game.getState().getZoneChangeCounter(source.getSourceId()) > this.zoneChangeCounter) {
            this.discard();
            return false;
        }
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject == null) {
            sourceObject = game.getPermanentEntering(source.getSourceId());
        }
        if (sourceObject == null) {
            return false;
        }
        Permanent troll = sourceObject;
        switch (layer) {
            case TypeChangingEffects_4: {
                troll.removeAllCardTypes(game);
                troll.addCardType(game, new CardType[]{CardType.ENCHANTMENT});
                troll.removeAllSubTypes(game);
                troll.addSubType(game, new SubType[]{SubType.AURA});
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                if (troll.getSpellAbility() == null) {
                    troll.addAbility((Ability)new SpellAbility(null, null), source.getSourceId(), game);
                }
                troll.getSpellAbility().getTargets().clear();
                troll.getSpellAbility().getEffects().clear();
                TargetPermanent auraTarget = new TargetPermanent(filter);
                troll.getSpellAbility().addTarget((Target)auraTarget);
                troll.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
                troll.addAbility((Ability)new EnchantAbility((Target)auraTarget), source.getSourceId(), game);
                troll.addAbility(OldGrowthTrollContinuousEffect.makeAbility(), source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }

    public OldGrowthTrollContinuousEffect copy() {
        return new OldGrowthTrollContinuousEffect(this);
    }

    private static Ability makeAbility() {
        SimpleActivatedAbility activatedAbility = new SimpleActivatedAbility((Effect)new CreateTokenEffect((Token)new TrollWarriorToken(), 1, true, false), (Cost)new GenericManaCost(1));
        activatedAbility.addCost((Cost)new TapSourceCost());
        SacrificeSourceCost cost = new SacrificeSourceCost();
        cost.setText("sacrifice this land");
        activatedAbility.addCost((Cost)cost);
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)new SimpleManaAbility(Zone.BATTLEFIELD, Mana.GreenMana((int)2), (Cost)new TapSourceCost()), AttachmentType.AURA).setText("enchanted Forest has \"{T}: Add {G}{G}\""));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)activatedAbility, AttachmentType.AURA).setText("and \"{1}, {T}, Sacrifice this land: Create a tapped 4/4 green Troll Warrior creature token with trample.\""));
        return ability;
    }
}

