/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class OmenMachineEffect2
extends OneShotEffect {
    public OmenMachineEffect2() {
        super(Outcome.PlayForFree);
        this.staticText = "that player exiles the top card of their library. If it's a land card, the player puts it onto the battlefield. Otherwise, the player casts it without paying its mana cost if able";
    }

    private OmenMachineEffect2(OmenMachineEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            Card card = player.getLibrary().getFromTop(game);
            if (card != null) {
                player.moveCards(card, Zone.EXILED, source, game);
                if (card.isLand(game)) {
                    player.moveCards(card, Zone.BATTLEFIELD, source, game);
                } else {
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
                    player.cast(player.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
                }
            }
            return true;
        }
        return false;
    }

    public OmenMachineEffect2 copy() {
        return new OmenMachineEffect2(this);
    }
}

