/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardWithDifferentNameInLibrary;
import mage.util.CardUtil;

class OmenpathJourneySearchEffect
extends OneShotEffect {
    OmenpathJourneySearchEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to five land cards that have different names, exile them, then shuffle";
    }

    private OmenpathJourneySearchEffect(OmenpathJourneySearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public OmenpathJourneySearchEffect copy() {
        return new OmenpathJourneySearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardWithDifferentNameInLibrary target = new TargetCardWithDifferentNameInLibrary(0, 5, (FilterCard)StaticFilters.FILTER_CARD_LAND);
        player.searchLibrary((TargetCardInLibrary)target, source, game);
        Set cards = target.getTargets().stream().map(uuid -> player.getLibrary().getCard(uuid, game)).filter(Objects::nonNull).collect(Collectors.toSet());
        player.moveCardsToExile(cards, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        player.shuffleLibrary(source, game);
        return true;
    }
}

