/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.mana.AddManaInAnyCombinationEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ColoredManaSymbol;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class OmnathLocusOfAllCardEffect
extends OneShotEffect {
    private static final String wubrg = "WUBRG";

    OmnathLocusOfAllCardEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. You may reveal that card if it has three or more colored mana symbols in its mana cost. If you do, add three mana in any combination of its colors and put it into your hand. If you don't reveal it, put it into your hand.";
    }

    private OmnathLocusOfAllCardEffect(OmnathLocusOfAllCardEffect effect) {
        super((OneShotEffect)effect);
    }

    public OmnathLocusOfAllCardEffect copy() {
        return new OmnathLocusOfAllCardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards(null, card, game);
        if (card.getManaCost().stream().map(ManaCost::getMana).map(Mana::getDifferentColors).filter(x -> x > 0).count() >= 3L && player.chooseUse(this.outcome, "Reveal " + card.getName() + '?', source, game)) {
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            ColoredManaSymbol[] colors = (ColoredManaSymbol[])card.getColor(game).getColors().stream().map(ObjectColor::getOneColoredManaSymbol).toArray(ColoredManaSymbol[]::new);
            if (colors.length > 0) {
                new AddManaInAnyCombinationEffect(3, colors).apply(game, source);
            }
        }
        player.moveCards(card, Zone.HAND, source, game);
        return true;
    }
}

