/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class OnceUponATimeWatcher
extends Watcher {
    private final Set<UUID> castSpells = new HashSet<UUID>();

    OnceUponATimeWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case SPELL_CAST: {
                this.castSpells.add(event.getPlayerId());
                return;
            }
            case BEGINNING_PHASE_PRE: {
                if (game.getTurnNum() != 1) break;
                this.castSpells.clear();
            }
        }
    }

    boolean getSpellsCastThisGame(UUID playerId) {
        return !this.castSpells.contains(playerId);
    }
}

