/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.LifelinkAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OnduRisingTriggeredAbility
extends DelayedTriggeredAbility {
    public OnduRisingTriggeredAbility() {
        super((Effect)new GainAbilityTargetEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn), Duration.EndOfTurn, false);
    }

    private OnduRisingTriggeredAbility(OnduRisingTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }

    public OnduRisingTriggeredAbility copy() {
        return new OnduRisingTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature attacks this turn, it gains lifelink until end of turn.";
    }
}

