/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class OneRingToRuleThemAllEffect
extends OneShotEffect {
    OneRingToRuleThemAllEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent loses 1 life for each creature card in that player's graveyard";
    }

    private OneRingToRuleThemAllEffect(OneRingToRuleThemAllEffect effect) {
        super((OneShotEffect)effect);
    }

    public OneRingToRuleThemAllEffect copy() {
        return new OneRingToRuleThemAllEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.loseLife(player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game), game, source, false);
        }
        return true;
    }
}

