/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OneWithTheStarsEffect
extends ContinuousEffectImpl {
    OneWithTheStarsEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "Enchanted permanent is an enchantment and loses all other card types.";
    }

    private OneWithTheStarsEffect(OneWithTheStarsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public OneWithTheStarsEffect copy() {
        return new OneWithTheStarsEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        permanent.setIsAllCreatureTypes(game, false);
        permanent.retainAllEnchantmentSubTypes(game);
        permanent.removeAllCardTypes(game);
        permanent.addCardType(game, new CardType[]{CardType.ENCHANTMENT});
        return true;
    }
}

