/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OonasBlackguardTriggeredAbility
extends TriggeredAbilityImpl {
    public OonasBlackguardTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DiscardTargetEffect(1), false);
    }

    private OonasBlackguardTriggeredAbility(OonasBlackguardTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public OonasBlackguardTriggeredAbility copy() {
        return new OonasBlackguardTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature;
        if (((DamagedPlayerEvent)event).isCombatDamage() && (creature = game.getPermanent(event.getSourceId())) != null && creature.isControlledBy(this.getControllerId()) && creature.getCounters(game).getCount(CounterType.P1P1) > 0) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control with a +1/+1 counter on it deals combat damage to a player, that player discards a card.";
    }
}

