/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.util.CardUtil;

class OozeFluxCreateTokenEffect
extends OneShotEffect {
    private final Token token;

    public OozeFluxCreateTokenEffect(Token token) {
        super(Outcome.PutCreatureInPlay);
        this.token = token;
        this.staticText = "Create an X/X green Ooze creature token, where X is the number of +1/+1 counters removed this way";
    }

    private OozeFluxCreateTokenEffect(OozeFluxCreateTokenEffect effect) {
        super((OneShotEffect)effect);
        this.token = effect.token.copy();
    }

    public OozeFluxCreateTokenEffect copy() {
        return new OozeFluxCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        Token tokenCopy = this.token.copy();
        tokenCopy.getAbilities().newId();
        tokenCopy.getPower().setModifiedBaseValue(xValue);
        tokenCopy.getToughness().setModifiedBaseValue(xValue);
        tokenCopy.putOntoBattlefield(1, game, source, source.getControllerId());
        return true;
    }
}

