/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.o.OozeToken;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OozeGardenCreateTokenEffect
extends OneShotEffect {
    OozeGardenCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create an X/X green Ooze creature token, where X is the sacrificed creature's power";
    }

    private OozeGardenCreateTokenEffect(OozeGardenCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public OozeGardenCreateTokenEffect copy() {
        return new OozeGardenCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int value = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            value = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getPower().getValue();
        }
        OozeToken token = new OozeToken(value);
        token.getAbilities().newId();
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        return true;
    }
}

