/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.List;
import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.o.OracleEnVecDestroyEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class OracleEnVecDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final int startingTurn;

    OracleEnVecDelayedTriggeredAbility(int startingTurn, List<UUID> chosenCreatures) {
        super((Effect)new OracleEnVecDestroyEffect(chosenCreatures), Duration.EndOfGame, true);
        this.startingTurn = startingTurn;
        this.setTriggerPhrase("At the beginning of that turn's end step, ");
    }

    private OracleEnVecDelayedTriggeredAbility(OracleEnVecDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.startingTurn = ability.startingTurn;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return this.startingTurn != game.getTurnNum() && game.isActivePlayer(event.getPlayerId());
    }

    public OracleEnVecDelayedTriggeredAbility copy() {
        return new OracleEnVecDelayedTriggeredAbility(this);
    }
}

