/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OracleEnVecMustAttackRequirementEffect
extends RequirementEffect {
    OracleEnVecMustAttackRequirementEffect() {
        super(Duration.UntilEndOfYourNextTurn);
    }

    private OracleEnVecMustAttackRequirementEffect(OracleEnVecMustAttackRequirementEffect effect) {
        super((RequirementEffect)effect);
    }

    public OracleEnVecMustAttackRequirementEffect copy() {
        return new OracleEnVecMustAttackRequirementEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getFirst(game, source) != null && this.getTargetPointer().getFirst(game, source).equals(permanent.getId()) && this.isYourNextTurn(game);
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Permanent perm = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (perm != null) {
            this.setStartingControllerAndTurnNum(game, perm.getControllerId(), game.getActivePlayerId());
        } else {
            this.discard();
        }
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getTurnPhaseType() == TurnPhase.END && this.isYourNextTurn(game);
    }

    public String getText(Mode mode) {
        return "{this} attack if able.";
    }
}

