/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.TargetSource;

class OraclesAttendantsReplacementEffect
extends ReplacementEffectImpl {
    private final TargetSource targetSource;

    public OraclesAttendantsReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.targetSource = new TargetSource();
        this.staticText = "All damage that would be dealt to target creature this turn by a source of your choice is dealt to {this} instead";
    }

    private OraclesAttendantsReplacementEffect(OraclesAttendantsReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.targetSource = effect.targetSource.copy();
    }

    public OraclesAttendantsReplacementEffect copy() {
        return new OraclesAttendantsReplacementEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.targetSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        DamageEvent damageEvent = (DamageEvent)event;
        if (permanent != null) {
            permanent.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable());
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getFirstTarget()) && event.getSourceId().equals(this.targetSource.getFirstTarget());
    }
}

