/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class OrcishLibrarianEffect
extends OneShotEffect {
    OrcishLibrarianEffect() {
        super(Outcome.Neutral);
        this.staticText = "Look at the top eight cards of your library. Exile four of them at random, then put the rest on top of your library in any order";
    }

    private OrcishLibrarianEffect(OrcishLibrarianEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrcishLibrarianEffect copy() {
        return new OrcishLibrarianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 8));
            if (!cards.isEmpty()) {
                CardsImpl randomExit = new CardsImpl();
                for (int i = 0; i < 4; ++i) {
                    Card card;
                    if (cards.isEmpty() || (card = cards.getRandom(game)) == null) continue;
                    randomExit.add(card);
                    cards.remove(card);
                }
                controller.moveCards((Cards)randomExit, Zone.EXILED, source, game);
                controller.lookAtCards(source, null, (Cards)cards, game);
                controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
            }
            return true;
        }
        return false;
    }
}

