/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantAttackAllEffect;
import mage.cards.o.OrissSamiteGuardianCantCastEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

class OrissSamiteGuardianEffect
extends OneShotEffect {
    OrissSamiteGuardianEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player can't cast spells this turn, and creatures that player controls can't attack this turn";
    }

    private OrissSamiteGuardianEffect(OrissSamiteGuardianEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrissSamiteGuardianEffect copy() {
        return new OrissSamiteGuardianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            game.addEffect((ContinuousEffect)new OrissSamiteGuardianCantCastEffect(), source);
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures that player controls");
            filter.add((Predicate)new ControllerIdPredicate(this.getTargetPointer().getFirst(game, source)));
            CantAttackAllEffect effect = new CantAttackAllEffect(Duration.EndOfTurn, filter);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

