/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OrvarTheAllFormEffect
extends OneShotEffect {
    OrvarTheAllFormEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of one of those permanents.";
    }

    private OrvarTheAllFormEffect(OrvarTheAllFormEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrvarTheAllFormEffect copy() {
        return new OrvarTheAllFormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (player == null || spell == null) {
            return false;
        }
        List predicates = spell.getSpellAbility().getModes().values().stream().map(Mode::getTargets).flatMap(Collection::stream).map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageItem::getId).map(PermanentIdPredicate::new).collect(Collectors.toList());
        if (predicates.isEmpty()) {
            return false;
        }
        FilterControlledPermanent filter = new FilterControlledPermanent("a permanent you control targeted by that spell");
        filter.add(Predicates.or(predicates));
        filter.add(Predicates.not((Predicate)new MageObjectReferencePredicate(new MageObjectReference(source))));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        return new CreateTokenCopyTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game)).apply(game, source);
    }
}

