/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OrzhovCharmDestroyAndLoseLifeEffect
extends OneShotEffect {
    OrzhovCharmDestroyAndLoseLifeEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy target creature and you lose life equal to its toughness";
    }

    private OrzhovCharmDestroyAndLoseLifeEffect(OrzhovCharmDestroyAndLoseLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrzhovCharmDestroyAndLoseLifeEffect copy() {
        return new OrzhovCharmDestroyAndLoseLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (target == null || controller == null) {
            return false;
        }
        int toughness = target.getToughness().getValue();
        target.destroy(source, game, false);
        if (toughness > 0) {
            controller.loseLife(toughness, game, source, false);
        }
        return true;
    }
}

