/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OsgirTheReconstructorCreateArtifactTokensEffect
extends OneShotEffect {
    OsgirTheReconstructorCreateArtifactTokensEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create two tokens that are copies of the exiled card.";
    }

    private OsgirTheReconstructorCreateArtifactTokensEffect(OsgirTheReconstructorCreateArtifactTokensEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = null;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof ExileFromGraveCost)) continue;
            card = (Card)((ExileFromGraveCost)cost).getExiledCards().get(0);
        }
        if (player == null || card == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(player.getId(), null, false, 2);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game.getState().getZoneChangeCounter(card.getId())));
        effect.apply(game, source);
        return true;
    }

    public OsgirTheReconstructorCreateArtifactTokensEffect copy() {
        return new OsgirTheReconstructorCreateArtifactTokensEffect(this);
    }
}

