/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.OrCost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OsseousSticktwisterEffect
extends OneShotEffect {
    OsseousSticktwisterEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent may sacrifice a nonland permanent of their choice or discard a card. Then {this} deals damage equal to its power to each opponent who didn't sacrifice a permanent or discard a card this way.";
    }

    OsseousSticktwisterEffect(OsseousSticktwisterEffect effect) {
        super((OneShotEffect)effect);
    }

    public OsseousSticktwisterEffect copy() {
        return new OsseousSticktwisterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        int dmgAmt = permanent == null ? 0 : permanent.getPower().getValue();
        ArrayList<UUID> playersToDamage = new ArrayList<UUID>();
        String message = "Sacrifice a nonland permanent or discard a card to avoid " + dmgAmt + " damage?";
        for (UUID uuid : game.getOpponents(source.getControllerId())) {
            OrCost cost;
            opponent = game.getPlayer(uuid);
            if (opponent == null || (cost = new OrCost("sacrifice a nonland permanent or discard a card", new Cost[]{new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND), new DiscardCardCost()})).canPay(source, source, opponent.getId(), game) && opponent.chooseUse(Outcome.Detriment, message, source, game) && cost.pay(source, game, source, opponent.getId(), false)) continue;
            playersToDamage.add(opponent.getId());
        }
        if (dmgAmt <= 0) {
            return true;
        }
        game.processAction();
        for (UUID uuid : playersToDamage) {
            opponent = game.getPlayer(uuid);
            if (opponent == null) continue;
            opponent.damage(dmgAmt, source, game);
        }
        return true;
    }
}

